<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAbUserNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('ab_user_notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('program_id')->unsigned();
			$table->integer('program_day_id')->unsigned();
			$table->integer('module_id')->unsigned();
			$table->integer('module_notification_id')->unsigned();
			$table->boolean('notification');
			$table->text('notification_text');
			$table->boolean('schedule');
			$table->text('schedule_text')->nullable();
			$table->integer('minute')->unsigned();
			$table->boolean('observe_cheat_day')->nullable();
			$table->boolean('response')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ab_user_notifications');
	}
}