<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('serviceType_id');

	public function beneficiary()
	{
		return $this->hasMany('Beneficiary_service', 'service_id');
	}

	public function service_type()
	{
		return $this->belongsTo('ServiceType');
	}

	public function organization()
	{
		return $this->belongsTo('Organization');
	}

}