<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Beneficiary extends Model 
{

    protected $table = 'Beneficiaries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('userInfo_id', 'date_of_birth', 'id_number', 'id_date', 'id_occupation', 'marital_status', 'education_level', 'major', 'address', 'house_ownership', 'house_type', 'family_male_members', 'family_female_members', 'rank_in_family', 'father_occupation', 'filling_form_date', 'full_name', 'health_description', 'koshak_sega_number', 'koshak_etimad', 'koshak_vehicle_type', 'koshak_toreed_office', 'koshak_driver_name', 'koshak_mobile_number');

    public function User()
    {
        return $this->belongsTo('UserInfo');
    }

    public function beneficiary_service()
    {
        return $this->hasMany('Beneficiary_service', 'beneficiary_id');
    }

    public function certificate()
    {
        return $this->hasMany('Certificate', 'beneficiary_id');
    }

    public function necessity()
    {
        return $this->hasMany('Necessity', 'beneficiary_id');
    }

    public function skill()
    {
        return $this->hasMany('Skill', 'beneficiary_id');
    }

    public function experience()
    {
        return $this->hasMany('Experience', 'beneficiary_id');
    }

    public function nationality()
    {
        return $this->belongsTo('Nationality');
    }

}