<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model 
{

    protected $table = 'Payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('supporter_id', 'amount', 'paymentMethod_id');

    public function supporter()
    {
        return $this->belongsTo('Supporter');
    }

    public function payment_method()
    {
        return $this->belongsTo('PaymentMethod');
    }

}