<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supporter extends Model 
{

    protected $table = 'Supporters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('userInfo_id', 'membershipType_id', 'specialty_id', 'referral_id');

    public function User()
    {
        return $this->belongsTo('UserInfo');
    }

    public function payment()
    {
        return $this->hasMany('Payment', 'supporter_id');
    }

    public function membership_type()
    {
        return $this->belongsTo('MembershipType');
    }

    public function specialty()
    {
        return $this->belongsTo('Specialty');
    }

    public function supporter_influence()
    {
        return $this->hasMany('Supporter_influence', 'supporter_id');
    }

    public function referral()
    {
        return $this->belongsTo('Referral');
    }

    public function supporter_contribution()
    {
        return $this->hasMany('Supporter_contribution', 'supporter_id');
    }

}