<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('mobile', 191);
			$table->string('father_name', 191);
			$table->string('mother_name', 191);
			$table->string('national_id', 191)->unique();
			$table->text('address');
			$table->integer('store_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}