<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHiresTable extends Migration {

	public function up()
	{
		Schema::create('hires', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->string('jamindar_name', 191);
			$table->string('payment_method', 191);
			$table->double('down_payment', 10,2)->default('0');
			$table->double('due_balance', 10,2)->default('0');
			$table->double('installament_price', 10,2)->default('0');
			$table->integer('term');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('hires');
	}
}