<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('store_id')->unsigned()->nullable();
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->double('subtotal', 10,2)->default('0');
			$table->double('total_discount', 10,2)->default('0');
			$table->double('total_vat', 10,2)->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}