<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('sales_id')->references('id')->on('sales')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('purchase_id')->references('id')->on('purchases')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('hires', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_store_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_store_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_store_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_sales_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_purchase_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_customer_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_supplier_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_product_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_store_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_store_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_supplier_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_store_id_foreign');
		});
		Schema::table('sales', function(Blueprint $table) {
			$table->dropForeign('sales_customer_id_foreign');
		});
		Schema::table('hires', function(Blueprint $table) {
			$table->dropForeign('hires_customer_id_foreign');
		});
	}
}