<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateProfileTable extends Migration {

	public function up()
	{
		Schema::create('candidate_profile', function(Blueprint $table) {
			$table->integer('user_id')->unsigned();
			$table->string('candidate_resume', 255)->nullable();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('job_category', 60)->nullable();
			$table->string('gender', 1)->nullable();
			$table->date('year_of_birth')->nullable();
			$table->string('country_of_birth', 50)->nullable();
			$table->string('marital_status', 50)->nullable();
			$table->integer('current_salary')->nullable();
			$table->string('disability', 1)->nullable();
			$table->string('current_country', 100)->nullable();
			$table->string('current_state', 50)->nullable();
			$table->string('current_city', 50)->nullable();
			$table->text('address')->nullable();
			$table->bigInteger('primary_phone')->nullable();
			$table->bigInteger('secondary_phone')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('candidate_profile');
	}
}