<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyTable extends Migration {

	public function up()
	{
		Schema::create('company', function(Blueprint $table) {
			$table->integer('user_id')->primary()->unsigned();
			$table->string('title', 100)->nullable();
			$table->string('company_type', 50)->nullable();
			$table->string('employees_count', 20)->nullable();
			$table->text('desc')->nullable();
			$table->string('img', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('company');
	}
}