<?php

namespace App/Employer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'Post';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('App\Employer\Company', 'user_id');
    }

    public function activities()
    {
        return $this->hasMany('\PostCanAc', 'post_id');
    }

}