<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Categorias_blog extends Model 
{

    protected $table = 'categorias_blog';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function posts()
    {
        return $this->hasMany('\Post', 'id_categoria');
    }

    public function padre()
    {
        return $this->belongsTo('\Categorias_blog', 'id_padre');
    }

}