<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarcasTable extends Migration {

	public function up()
	{
		Schema::create('marcas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre', 255)->nullable();
			$table->string('slug', 255)->unique();
			$table->string('breadcrumb', 255)->nullable();
			$table->string('h1', 255)->nullable();
			$table->string('title', 255)->nullable();
			$table->string('description', 200)->nullable();
			$table->string('robots', 100)->default('index,follow');
			$table->string('canonical', 255)->nullable();
			$table->string('title_tc', 255)->nullable();
			$table->string('description_tc', 255)->nullable();
			$table->string('imagen_tc')->nullable();
			$table->string('title_og', 255)->nullable();
			$table->string('description_og')->nullable();
			$table->string('imagen_og')->nullable();
			$table->text('descripcion_corta')->nullable();
			$table->text('descripcion_larga')->nullable();
			$table->string('logotipo')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('marcas');
	}
}