<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUbicacionesTable extends Migration {

	public function up()
	{
		Schema::create('ubicaciones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_padre')->unsigned()->nullable();
			$table->integer('orden')->nullable()->default('0');
			$table->string('nombre', 255)->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('breadcrumb', 255)->nullable();
			$table->string('h1', 255)->nullable();
			$table->string('title', 255)->nullable();
			$table->string('description', 200)->nullable();
			$table->string('robots', 100);
			$table->string('canonical', 255)->nullable();
			$table->string('title_tc', 255)->nullable();
			$table->string('description_tc', 255)->nullable();
			$table->string('imagen_tc')->nullable();
			$table->string('title_og', 255)->nullable();
			$table->string('description_og')->nullable();
			$table->string('imagen_og')->nullable();
			$table->text('descripcion_corta')->nullable();
			$table->text('descripcion_larga')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->string('imagen_ubicacion')->nullable();
			$table->text('gmaps')->nullable();
			$table->string('gmaps_link', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('ubicaciones');
	}
}