<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSlugsTable extends Migration {

	public function up()
	{
		Schema::create('slugs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug')->unique();
			$table->enum('accion', array('200', '301', '302', '404', '410'));
			$table->string('destino')->nullable();
			$table->string('tabla_rel');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('slugs');
	}
}