<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('city_id');
			$table->integer('request_id');
			$table->string('name', 100);
			$table->string('email', 100)->unique();
			$table->date('birth_date');
			$table->string('blood_type', 10);
			$table->string('government');
			$table->string('city');
			$table->string('mobile', 20)->unique();
			$table->string('password', 255);
			$table->string('pass_confirmation', 255)->unique();
			$table->date('last_don_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}