<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('hmo_cases', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('hmo_case_statuses')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hmo_case_documents', function(Blueprint $table) {
			$table->foreign('document_type_id')->references('id')->on('hmo_case_document_types')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('hmo_case_documents', function(Blueprint $table) {
			$table->foreign('hmo_case_id')->references('id')->on('hmo_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('case_officer_hmo_cases', function(Blueprint $table) {
			$table->foreign('hmo_case_id')->references('id')->on('hmo_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_case_associates', function(Blueprint $table) {
			$table->foreign('hmo_case_id')->references('id')->on('hmo_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hmo_case_declarations', function(Blueprint $table) {
			$table->foreign('hmo_case_id')->references('id')->on('hmo_cases')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('hmo_cases', function(Blueprint $table) {
			$table->dropForeign('hmo_cases_status_id_foreign');
		});
		Schema::table('hmo_case_documents', function(Blueprint $table) {
			$table->dropForeign('hmo_case_documents_document_type_id_foreign');
		});
		Schema::table('hmo_case_documents', function(Blueprint $table) {
			$table->dropForeign('hmo_case_documents_hmo_case_id_foreign');
		});
		Schema::table('case_officer_hmo_cases', function(Blueprint $table) {
			$table->dropForeign('case_officer_hmo_cases_hmo_case_id_foreign');
		});
		Schema::table('hmo_case_associates', function(Blueprint $table) {
			$table->dropForeign('hmo_case_associates_hmo_case_id_foreign');
		});
		Schema::table('hmo_case_declarations', function(Blueprint $table) {
			$table->dropForeign('hmo_case_declarations_hmo_case_id_foreign');
		});
	}
}