<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned();
			$table->enum('status', array('NONE', 'PENDING', 'APPROVED', 'REJECTED'))->index();
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}