<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoansTable extends Migration {

	public function up()
	{
		Schema::create('loans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('customer_id')->unsigned();
			$table->integer('loan_type_id')->unsigned()->index();
			$table->date('next_payment_due')->index();
			$table->decimal('cache_balance');
			$table->string('contract_number')->unique();
		});
	}

	public function down()
	{
		Schema::drop('loans');
	}
}