<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePreferenceTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('preference_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('preference_id')->unique()->unsigned();
			$table->string('locale')->unique();
			$table->string('name');
		});
	}

	public function down()
	{
		Schema::drop('preference_translations');
	}
}