<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function translations()
	{
		return $this->hasMany('App\Models\CountryTranslation');
	}

	public function currency()
	{
		return $this->belongsTo('Currency');
	}

}