<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Coupon extends Eloquent {

	protected $table = 'coupons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsToMany('App\Models\User', 'coupon_users', 'coupon_id', 'user_id');
	}

	public function store()
	{
		return $this->belongsTo('App\Models\Store');
	}

}