<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Drink extends Eloquent {

	protected $table = 'drinks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function items()
	{
		return $this->belongsToMany('App\Models\Item', 'item_drinks', 'drink_id', 'item_id');
	}

}