<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Status extends Eloquent {

	protected $table = 'statuses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order', 'order_statuses', 'status_id', 'order_id')->withTimestamps();
	}

}