<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Education extends Eloquent {

	protected $table = 'candidate_cv_educations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'university_name', 'university_type_id', 'field_of_study_id', 'start_date', 'end_date', 'currently_educating', 'degree_level_id', 'gpa');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function university()
	{
		return $this->belongsTo('App\Lookup', 'university_type_id');
	}

	public function fieldOfStudy()
	{
		return $this->belongsTo('App\Lookup', 'field_of_study_id');
	}

	public function degreeLevel()
	{
		return $this->belongsTo('App\Lookup', 'degree_level_id');
	}

}