<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Skill extends Eloquent {

	protected $table = 'candidate_cv_skills';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('cv_id', 'title', 'skill_level_id', 'skill_type_id');

	public function cv()
	{
		return $this->belongsTo('App\CandidateCV', 'cv_id');
	}

	public function skillLevel()
	{
		return $this->belongsTo('App\Lookup', 'skill_level_id');
	}

}