<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidateCvTargetJobTable extends Migration {

	public function up()
	{
		Schema::create('candidate_cv_target_job', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('cv_id')->unsigned();
			$table->string('title', 255);
			$table->integer('career_level_id')->unsigned();
			$table->text('career_objectives')->nullable();
			$table->boolean('willing_to_relocate')->nullable()->default(0);
			$table->integer('willing_to_travel_id')->unsigned();
			$table->integer('employment_type_id')->unsigned();
			$table->integer('employment_status_id')->unsigned();
			$table->integer('salary_expected')->nullable();
			$table->integer('salary_expected_currency_id')->unsigned()->nullable();
			$table->integer('salary_expected_period_id')->unsigned();
			$table->text('expected_benefits')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('candidate_cv_target_job');
	}
}