<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatePhoneNumbersTable extends Migration {

	public function up()
	{
		Schema::create('candidate_phone_numbers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('candidate_id')->unsigned();
			$table->integer('country_code_id')->unsigned();
			$table->string('area_code', 10)->nullable();
			$table->string('phone_number', 30);
			$table->integer('type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('candidate_phone_numbers');
	}
}