<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('type');
			$table->string('title', 255);
			$table->string('title_farsi', 255)->nullable();
			$table->string('country_code', 10)->nullable();
			$table->integer('sequence');
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}