<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLookupsTable extends Migration {

	public function up()
	{
		Schema::create('lookups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 30);
			$table->string('title_farsi', 30)->nullable();
			$table->integer('sequence');
			$table->integer('subscriber_count')->default('0');
			$table->integer('value')->nullable();
			$table->integer('type')->unique();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('lookups');
	}
}