<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActionsTable extends Migration {

	public function up()
	{
		Schema::create('actions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->unique();
			$table->text('description')->nullable();
			$table->boolean('enabled')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('actions');
	}
}