<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SoldPackage extends Model 
{

    protected $table = 'sold_packages';
    public $timestamps = true;
    protected $fillable = array('inherit_id', 'package_name', 'price', 'pax', 'total');
    protected $visible = array('package_name', 'price', 'pax', 'total');

    public function package()
    {
        return $this->belongsTo('Package', 'inherit_id');
    }

    public function directSell()
    {
        return $this->belongsTo('DirectSell', 'direct_sells_id');
    }

}