<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Agency extends Model 
{

    protected $table = 'agencies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'registered_name', 'rnc', 'email', 'phone', 'address', 'description', 'enable');
    protected $visible = array('email');

    public function reservations()
    {
        return $this->hasMany('Reservation', 'agency_id');
    }

    public function agents()
    {
        return $this->hasMany('Agent');
    }

}