<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('username', 'name', 'last_name');

    public function role()
    {
        return $this->belongsToMany('Role', 'user_id');
    }

    public function attempts()
    {
        return $this->hasMany('Login_attempts');
    }

}