<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 30);
			$table->string('email', 30);
			$table->string('phone', 15)->nullable();
			$table->datetime('email_verified_at');
			$table->string('password');
			$table->string('remember_token', 64);
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->boolean('ban')->default(FALSE);
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}