<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function stores()
	{
		return $this->belongsToMany('Store');
	}

	public function orders()
	{
		return $this->belongsToMany('Order');
	}

}