<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function order()
	{
		return $this->belongsTo('Order');
	}

	public function store()
	{
		return $this->belongsTo('Store');
	}

}