<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->foreign('placed_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_groups', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users_groups', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products_stores', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products_stores', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_account_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_product_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_store_id_foreign');
		});
		Schema::table('ratings', function(Blueprint $table) {
			$table->dropForeign('ratings_placed_by_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_user_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_order_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_store_id_foreign');
		});
		Schema::table('users_groups', function(Blueprint $table) {
			$table->dropForeign('users_groups_user_id_foreign');
		});
		Schema::table('users_groups', function(Blueprint $table) {
			$table->dropForeign('users_groups_group_id_foreign');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->dropForeign('orders_products_order_id_foreign');
		});
		Schema::table('orders_products', function(Blueprint $table) {
			$table->dropForeign('orders_products_product_id_foreign');
		});
		Schema::table('products_stores', function(Blueprint $table) {
			$table->dropForeign('products_stores_product_id_foreign');
		});
		Schema::table('products_stores', function(Blueprint $table) {
			$table->dropForeign('products_stores_store_id_foreign');
		});
	}
}