<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50)->unique();
			$table->string('email');
			$table->string('password', 100);
			$table->string('avatar');
			$table->tinyInteger('role');
			$table->timestamp('created_at');
			$table->timestamp('deleted_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}