<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('country_id')->unsigned();
			$table->string('postal_code');
			$table->string('city');
			$table->string('street');
			$table->string('number');
			$table->enum('type', array('DEFAULT', 'CONTACT'));
			$table->integer('application_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}