<?php

namespace App\Models;

class Application extends Eloquent {

	protected $table = 'applications';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

	public function exams()
	{
		return $this->belongsToMany('Exam');
	}

	public function documents()
	{
		return $this->hasMany('Document');
	}

	public function stateHistories()
	{
		return $this->hasMany('StateHistory');
	}

	public function educations()
	{
		return $this->hasMany('Education');
	}

	public function addresses()
	{
		return $this->hasMany('Address');
	}

	public function languages()
	{
		return $this->belongsToMany('Language');
	}

	public function applicationPeriod()
	{
		return $this->belongsTo('ApplicationPeriod');
	}

}