<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Anketa', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Anketa', function(Blueprint $table) {
			$table->foreign('semeyka_id')->references('id')->on('semeyka')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('spravka_client', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Anketa')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invalids', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Anketa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Anketa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Anketa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->foreign('otdelenie_id')->references('id')->on('otdels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_client_pivots', function(Blueprint $table) {
			$table->foreign('manger_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_client_pivots', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Anketa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Anketa')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Anketa', function(Blueprint $table) {
			$table->dropForeign('Anketa_user_id_foreign');
		});
		Schema::table('Anketa', function(Blueprint $table) {
			$table->dropForeign('Anketa_semeyka_id_foreign');
		});
		Schema::table('spravka_client', function(Blueprint $table) {
			$table->dropForeign('spravka_client_client_id_foreign');
		});
		Schema::table('invalids', function(Blueprint $table) {
			$table->dropForeign('invalids_client_id_foreign');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->dropForeign('journal_user_id_foreign');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->dropForeign('journal_client_id_foreign');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->dropForeign('journal_otdelenie_id_foreign');
		});
		Schema::table('journal', function(Blueprint $table) {
			$table->dropForeign('journal_service_id_foreign');
		});
		Schema::table('user_client_pivots', function(Blueprint $table) {
			$table->dropForeign('user_client_pivots_manger_id_foreign');
		});
		Schema::table('user_client_pivots', function(Blueprint $table) {
			$table->dropForeign('user_client_pivots_client_id_foreign');
		});
		Schema::table('passports', function(Blueprint $table) {
			$table->dropForeign('passports_client_id_foreign');
		});
	}
}