<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'Anketa';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id', 'user_id', 'prichinas_id', 'semeyka_id');
	protected $fillable = array('familia', 'imya', 'otchestvo', 'brithday', 'phone_city', 'phone_mob', 'sniils', 'photo', 'barcode', 'note', 'prichinas_note', 'pricinas_date_ot', 'prichinas_stop', 'pricinas_date_do');

	public function inquiries()
	{
		return $this->hasMany('Spravka');
	}

	public function demands()
	{
		return $this->hasMany('Journal');
	}

	public function Invalids()
	{
		return $this->hasOne('Invalid');
	}

	public function managers()
	{
		return $this->hasMany('User_Client_pivot');
	}

	public function passport()
	{
		return $this->hasOne('Passport', 'id');
	}

}