<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('familia', 'imya', 'otchestvo', 'dolgnost');

	public function Clients()
	{
		return $this->hasMany('User_Client_pivot');
	}

	public function role()
	{
		return $this->belongsToMany('Role-User', 'id');
	}

}