<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCollectionsTable extends Migration {

	public function up()
	{
		Schema::create('collections', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('value');
			$table->integer('percentage');
			$table->date('date');
			$table->enum('status', array('collected', 'not_collected'));
			$table->enum('delay', array('0', '1'));
			$table->date('postponedDate');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('collections');
	}
}