<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactPersonsTable extends Migration {

	public function up()
	{
		Schema::create('contact_persons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('title_id');
			$table->string('position');
			$table->string('fullname');
			$table->string('phone');
			$table->string('mobile');
			$table->integer('nationality_id');
			$table->integer('company_id');
			$table->enum('leadstatus', array(''));
			$table->string('email');
			$table->text('website');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contact_persons');
	}
}