<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company_name');
			$table->integer('employees_number');
			$table->enum('rating', array(''));
			$table->string('company_logo');
			$table->text('description');
			$table->integer('Industry_id');
			$table->string('annual_revenue');
			$table->integer('contract_id')->unsigned();
			$table->text('introduction');
			$table->text('closing');
			$table->string('policy');
			$table->enum('leadstatus', array('connected', 'notconnect'));
			$table->text('activity');
			$table->string('company_type');
			$table->integer('sub_id');
			$table->integer('invoice_id');
			$table->integer('lead_source_id');
			$table->string('currency_id');
			$table->integer('tax_bill');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}