<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyAddressesTable extends Migration {

	public function up()
	{
		Schema::create('company_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('street');
			$table->string('state');
			$table->integer('city_id');
			$table->integer('company_id');
			$table->string('zip_code');
			$table->integer('country_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('company_addresses');
	}
}