<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTournamentsTable extends Migration {

	public function up()
	{
		Schema::create('tournaments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('city_id');
			$table->string('lat')->nullable();
			$table->string('lon');
			$table->bigInteger('complexe_id');
			$table->timestamp('start_at')->nullable();
			$table->timestamp('ended_at');
			$table->timestamp('register_start_at')->nullable();
			$table->timestamp('register_end_at');
			$table->timestamp('publishing_at');
			$table->enum('plan_type', array('final_last_day', 'level_own_day'));
			$table->bigInteger('application_id')->nullable();
			$table->string('phone_number');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tournaments');
	}
}